<?php


class ImageVisual extends Widget
{

    /**
     * Submit user input
     * @var boolean
     */
    protected $blnSubmitInput = true;

    /**
     * Add a for attribute
     * @var boolean
     */
    protected $blnForAttribute = true;

    /**
     * Template
     * @var string
     */
    protected $strTemplate = 'form_widget_formfield_visual';

    /**
     * Add specific attributes
     * @param string
     * @param mixed
     */
    public function __set($strKey, $varValue)
    {
        switch ($strKey) {
            case 'mandatory':
                if ($varValue) {
                    $this->arrAttributes['required'] = 'required';
                } else {
                    unset($this->arrAttributes['required']);
                }
                parent::__set($strKey, $varValue);
                break;

            default:
                parent::__set($strKey, $varValue);
                break;
        }
    }

    /**
     * Generate the widget and return it as string
     * @return string
     */
    public function generate()
    {
        $strImage = VisualFormFields::createImage('mod_visual_formfields_img', $this, $this->singleSRC, $this->alt, $this->title);
        return $strImage;
    }
}
